﻿
Type.registerNamespace("View");

// Constructor
View.Preview = function(element) {

    View.Preview.initializeBase(this, [element]);
    
    this._elem_PreivewXiaLian = "dynamicXiaLianwithHengpi";
    this._elem_PreivewShangLian = "dynamicShangLianwithHengpi";
    this._elem_PreviewHengPi = "dynamicHengpi";
    this._CONST_PREFIX_PREVIEW = "prev";
    
    $create(View.LianPreview, null, null, null, $get(this._elem_PreivewXiaLian));
    $create(View.LianPreview, null, null ,null, $get(this._elem_PreivewShangLian));
    $create(View.HPPreview, null, null ,null, $get(this._elem_PreviewHengPi));

    this._SL_preview = $find(this._elem_PreivewShangLian);
    this._XL_preview = $find(this._elem_PreivewXiaLian);
    this._SL_preview._type = gConst_ShangLian;
    this._XL_preview._type = gConst_XiaLian;
    this._HP_preview = $find(this._elem_PreviewHengPi);
}

View.Preview.prototype = 
{
    /// <summary>
	/// This method is to set the style of display
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="isDisplayed">Whether the element should be display</param>
    set_display: function (isDisplayed){
        var dis = isDisplayed ? "" : "none";
        this.get_element().style.display = dis;
    },
    
    /// <summary>
	/// This method is to set shanglian or xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="ShangLianORXiaLian">set xianglian or xialian</param>
    /// <param name="lian">content of shanglian or xialian</param>
    set_lian: function(ShangLianORXiaLian,lian)
    {
        if(ShangLianORXiaLian == gConst_ShangLian )
        {
            this._SL_preview.set_lian( lian );
            this._SL_preview.set_length( lian.length );
            this._XL_preview.set_length( lian.length );
            this._HP_preview.set_lianlength( lian.length );
        }
        else
        {
            this._XL_preview.set_lian( lian );
        }
    },
    
    /// <summary>
	/// This method is to set hengpi.
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="hengpi">content of hengpi</param>
    set_hengpi: function(hengpi)
    {
        this._HP_preview.set_hengpi(hengpi);
    },
    /// <summary>
	/// This method is to get hengpi.
	/// </summary>
    /// <accessibility>public</accessibility>
    get_hengpi: function()
    {
        return this._HP_preview.get_hengpi();
    },
    
    /// <summary>
	/// This method is to get one word in shanglian according the index
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="index">Index of the word in shanglian</param>
	/// <return value>If success, it will return the word according the index</return value>
    get_shanglian_word: function(index)
    {
        if($get( this._CONST_PREFIX_PREVIEW + gConst_ShangLian + index )!=null)
        {
            return $get( this._CONST_PREFIX_PREVIEW + gConst_ShangLian + index ).value;
        }
        else
        {
            return "";
        }
    },
    /// <summary>
	/// This method is to get one word in xialian according the index
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="index">Index of the word in xialian</param>
	/// <return value>If success, it will return the word according the index</return value>
    get_xialian_word: function(index)
    {
        if($get( this._CONST_PREFIX_PREVIEW + gConst_XiaLian + index )!=null)
        {
            return $get( this._CONST_PREFIX_PREVIEW + gConst_XiaLian + index ).value;
        }
        else
        {
            return "";
        }
    },
    
    /// <summary>
	/// This method is to clear one word in shanglian according the index.
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="index">Index of the word in shanglian.</param>
    clear_shanglian_word: function(index)
    {
        this._SL_preview.clear_word(index);
    },
    
    /// <summary>
	/// This method is to clear one word in xialian according the index.
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="index">Index of the word in xialian.</param>
	clear_xialian_word: function(index)
	{
        this._XL_preview.clear_word(index);
    },
    
    /// <summary>
	/// This method is to construct shanglian,xialian and hengpi preview.
	/// </summary>
    /// <accessibility>public</accessibility>
    GenerateLian: function(){
        this._HP_preview.GenerateHP();
        this._SL_preview.GenerateLian();
        this._XL_preview.GenerateLian();
    },
    /// <summary>
	/// This method is to update some word of shanglian .
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="startIdx">begin index of the word which will be clear.</param>
    /// <param name="content">content of shanglian .</param>
    updateShangLian: function( startIdx, content ){
        this._SL_preview.updateDynamicLian( startIdx, content);

    },
    /// <summary>
	/// This method is to update some word of  xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="startIdx">begin index of the word which will be clear.</param>
    /// <param name="content">content of  xialian.</param>
    updateXiaLian: function( startIdx, content ){
        this._XL_preview.updateDynamicLian( startIdx, content);
    },
    
    /// <summary>
	/// This method is to update content of hengpi
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="content">content of hengpi</param>
    updateDynamicHP: function(content){
        this._HP_preview.updateHPPreview(content);
    },
    
    /// <summary>
	/// This method is to clear the whole shanglian, xialian and hengpi.
	/// </summary>
    /// <accessibility>public</accessibility>
    clear: function(){
        this._HP_preview.clear();
        this._SL_preview.clear();
        this._XL_preview.clear();
    }
}
View.Preview.registerClass('View.Preview', Sys.UI.Control);
//////////////////////////////////////////////////////////////////////////

Type.registerNamespace("View");

View.LianPreview = function(element) {

    View.LianPreview.initializeBase(this, [element]);
    this._type = "";
    this._lianText = "";
    this._length;
    this._CONST_PREFIX_PREVIEW = "prev";
    this._CONST_BIG_FONT = 30;
    this._CONST_SMALL_FONT = 25;
}

View.LianPreview.prototype = 
{
    /// <summary>
	/// This method is to set the style of display
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="isDisplayed">Whether the element should be display</param>
    set_display: function (isDisplayed)
    {
        var dis = isDisplayed ? "" : "none";
        this.get_element().style.display = dis;
    },
    
    /// <summary>
	/// This method is to set content of shanglian or xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="lian">content of shanglian or xialian</param>
    set_lian: function (lian)
    {
        this._lianText = lian.replace(' ', '');
    },
    
    /// <summary>
	/// This method is to set length of shanglian or xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="l">length of shanglian or xialian</param>
    set_length: function(l)
    {
        this._length = l;
    },
    
    /// <summary>
	/// This method is to clear the whole shanglian or xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    clear: function()
    {
        if(this.get_element().firstChild)
	        this.get_element().removeChild(this.get_element().firstChild);
    },
    
    /// <summary>
	/// This method is to clear one word in shanglian or xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="index">index of the word which will be clear.</param>
    clear_word: function(index)
    {
        if( $get( this._CONST_PREFIX_PREVIEW + this._type + index ) != null )
	    {
	        $get( this._CONST_PREFIX_PREVIEW + this._type + index ).value = "";
	    }
    },
    
    /// <summary>
	/// This method is to update some word of shanglian or xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="startIdx">begin index of the word which will be clear.</param>
    /// <param name="content">content of shanglian or xialian</param>
    updateDynamicLian: function( startIdx, content )
    {
        var nCurIdx = parseInt( startIdx );
	    var nContentLength = content.length;
        for ( var i = 0; i < nContentLength ; i++ )
	    {

		    //change preview 
		    if( $get( this._CONST_PREFIX_PREVIEW + this._type + ( nCurIdx + i ) ) != null )
		    {
		        $get( this._CONST_PREFIX_PREVIEW + this._type + ( nCurIdx + i ) ).value = content.charAt( i );
		    }
	    }
    },
    
    /// <summary>
	/// This method is to generate the dynamic ShangLian and XiaLian input cells 
	/// </summary>
    /// <accessibility>public</accessibility>
    GenerateLian: function()
    {
        var tdheight = parseInt(285/this._length);
        var table = document.createElement("table");
        table.style.cssText='margin-left: auto; margin-right: auto';
        var tmp = document.createElement('TBODY');
	    table.appendChild(tmp);
    	
        for( i=0; i<this._length; i++)
        {
            // Generate ShangLian dynamic area
            var row = document.createElement("tr");
            var col = document.createElement("td");
            col.style.cssText = "text-align: center; width: 50%;height: " + tdheight + "px;";
            var input;
            
            input = document.createElement("input");
            input.type = "text";
            input.id = this._CONST_PREFIX_PREVIEW + this._type + i;
            input.value = this._lianText.charAt(i);
            input.maxLength = 1;
            input.className= "previewFont";
            input.readOnly = true;
           
            col.appendChild(input);        
            row.appendChild(col);
            tmp.appendChild(row);
            
        }
        this.clear();
        //Add tbody in the table and the method of appendChild will work.
        this.get_element().appendChild(table);
    }
    
}
View.LianPreview.registerClass('View.LianPreview', Sys.UI.Control);

//////////////////////////////////////////////////////////////////////////

Type.registerNamespace("View");

View.HPPreview = function(element) 
{

    View.HPPreview.initializeBase(this, [element]);
    this._hpText = "";
    this._lianlength;
    this._CONST_PREFIX_PREVIEW = "prev";
    this._CONST_BIG_FONT = 30;
    this._CONST_SMALL_FONT = 25;
}

View.HPPreview.prototype = 
{
    /// <summary>
	/// This method is to set hengpi text
	/// </summary>
    set_hengpi: function (hp)
    {
        this._hpText = hp.replace(' ', '');
    },
    /// <summary>
	/// This method is to get hengpi text
	/// </summary>
    get_hengpi: function()
    {
        return this._hpText;
    },
    /// <summary>
	/// This method is to set hengpi length
	/// </summary>
    set_lianlength: function(l)
    {
        this._lianlength = l;
    },
    
    /// <summary>
	/// This method is to set the style of display
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="isDisplayed">Whether the element should be display</param>
    set_display: function (isDisplayed)
    {
        var dis = isDisplayed ? "" : "none";
        this.get_element().style.display = dis;
    },
    
       
    /// <summary>
	/// This method is to clear the whole shanglian or xialian
	/// </summary>
    /// <accessibility>public</accessibility>
    clear: function()
    {
        if(this.get_element().firstChild)
	        this.get_element().removeChild(this.get_element().firstChild);
    },
    
    /// <summary>
	/// This method is to update content of hengpi
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="content">content of hengpi</param>
    updateHPPreview: function( content )
    {

		if( $get( gConst_Hengpi ) != null )
		{
		    $get( gConst_Hengpi ).value = content;
	    }
    },
    
    /// <summary>
	/// This method is to generate the hengpu input cells 
	/// </summary>
    /// <accessibility>public</accessibility>
    GenerateHP: function()
    {
        var table = document.createElement("table");
        table.style.cssText='margin-left: auto; margin-right: auto';
        var tmp = document.createElement('TBODY');
	    table.appendChild(tmp);
        var tableHP = document.createElement("table");
        tableHP.style.cssText='margin-left: auto; margin-right: auto; text-align:center;';
	    var tmpHP = document.createElement('TBODY');
        var rowHP = document.createElement("tr");
        var colHP = document.createElement("td");
        colHP.style.cssText = "vertical-align:middle; text-align: center; margin-left: auto; margin-right: auto;width: 100%;height: 100%;";
        var inputHP;
        
        inputHP = document.createElement("input");
        inputHP.type = "text";
        inputHP.id = gConst_Hengpi ;
        inputHP.maxLength = 4;
        inputHP.className= "previewHPFont";
        inputHP.readOnly = true;
        inputHP.value = this._hpText;
        
        colHP.appendChild(inputHP);        
        rowHP.appendChild(colHP);
	    tmpHP.appendChild(rowHP);
	    tableHP.appendChild(tmpHP);
	    this.clear();
	    this.get_element().appendChild(tableHP);
            
    }
    
}
View.HPPreview.registerClass('View.HPPreview', Sys.UI.Control);

// Since this script is not loaded by System.Web.Handlers.ScriptResourceHandler
// invoke Sys.Application.notifyScriptLoaded to notify ScriptManager 
// that this is the end of the script.
if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();